/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.images;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.VWImageIcon;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class VWBaseImageLoader {
    public static JButton createIconButton(Class resourceLoader, String imageFile, String toolTipText) {
        try {
            JButton button = null;
            ImageIcon icon = VWBaseImageLoader.createImageIcon(resourceLoader, imageFile);
            button = icon != null ? new JButton(icon) : new JButton(toolTipText);
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setToolTipText(toolTipText);
            button.setActionCommand(toolTipText);
            VWAccessibilityHelper.setAccessibility(button, null, toolTipText, toolTipText);
            return button;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public static JToggleButton createIconToggleButton(Class resourceLoader, String imageFile, String toolTipText) {
        try {
            JToggleButton button = null;
            ImageIcon icon = VWBaseImageLoader.createImageIcon(resourceLoader, imageFile);
            button = icon != null ? new JToggleButton(icon) : new JToggleButton(toolTipText);
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setToolTipText(toolTipText);
            button.setActionCommand(toolTipText);
            return button;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public static ImageIcon createImageIcon(Class resourceLoader, String imageFile) {
        try {
            return new VWImageIcon(resourceLoader.getResource(imageFile));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public static ImageIcon createImageIconNoMessage(Class resourceLoader, String imageFile) {
        try {
            return new VWImageIcon(resourceLoader.getResource(imageFile));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static AbstractButton createToolBarButton(Class resourceLoader, String imageFile, String toolTipText, boolean bToggleButton) {
        try {
            AbstractButton button = null;
            button = bToggleButton ? VWBaseImageLoader.createIconToggleButton(resourceLoader, imageFile, toolTipText) : VWBaseImageLoader.createIconButton(resourceLoader, imageFile, toolTipText);
            if (button != null) {
                String imageName = imageFile.substring(0, imageFile.indexOf(".gif")) + "_p.gif";
                ImageIcon icon = VWBaseImageLoader.createImageIcon(resourceLoader, imageName);
                if (icon != null) {
                    button.setSelectedIcon(icon);
                }
                if ((icon = VWBaseImageLoader.createImageIcon(resourceLoader, imageName = imageFile.substring(0, imageFile.indexOf(".gif")) + "_p.gif")) != null) {
                    button.setPressedIcon(icon);
                }
                if ((icon = VWBaseImageLoader.createImageIcon(resourceLoader, imageName = imageFile.substring(0, imageFile.indexOf(".gif")) + "_d.gif")) != null) {
                    button.setDisabledIcon(icon);
                }
                if ((icon = VWBaseImageLoader.createImageIcon(resourceLoader, imageName = imageFile.substring(0, imageFile.indexOf(".gif")) + "_h.gif")) != null) {
                    button.setRolloverIcon(icon);
                }
                button.setBorderPainted(false);
                button.setContentAreaFilled(false);
                button.setFocusPainted(true);
            }
            return button;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public static void addToolbarSeparator(JToolBar toolBar) {
        JButton button = VWBaseImageLoader.createIconButton(VWBaseImageLoader.class, "separator.gif", null);
        if (button != null) {
            ImageIcon icon = VWBaseImageLoader.createImageIcon(VWBaseImageLoader.class, "separator.gif");
            if (icon != null) {
                button.setDisabledIcon(icon);
            }
            button.setEnabled(false);
            button.setBorderPainted(false);
            button.setContentAreaFilled(false);
            button.setFocusPainted(true);
            toolBar.add(button);
            VWAccessibilityHelper.setAccessibility(button, toolBar, VWResource.s_toolbarSeperator, VWResource.s_toolbarSeperator);
        } else {
            toolBar.addSeparator();
        }
    }

    public static void enableIconComponentOrientation(AbstractButton button) {
        if (button == null) {
            return;
        }
        Icon icon = button.getIcon();
        if (icon != null && icon instanceof VWImageIcon) {
            ((VWImageIcon)icon).useCompOrientation(true);
        }
        if ((icon = button.getSelectedIcon()) != null && icon instanceof VWImageIcon) {
            ((VWImageIcon)icon).useCompOrientation(true);
        }
        if ((icon = button.getPressedIcon()) != null && icon instanceof VWImageIcon) {
            ((VWImageIcon)icon).useCompOrientation(true);
        }
        if ((icon = button.getDisabledIcon()) != null && icon instanceof VWImageIcon) {
            ((VWImageIcon)icon).useCompOrientation(true);
        }
        if ((icon = button.getRolloverIcon()) != null && icon instanceof VWImageIcon) {
            ((VWImageIcon)icon).useCompOrientation(true);
        }
    }
}

